package jamezo97.clonecraft.network;

import jamezo97.clonecraft.entity.clone.EntityClone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.util.DamageSource;
import cpw.mods.fml.relauncher.Side;

public class Handler10KillClone extends Handler{
	@Value(id = 0)
	public int entityId;

	public Handler10KillClone() {

	}

	public Handler10KillClone(int entityId) {
		this.entityId = entityId;
	}

	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		if(side == Side.SERVER){
			EntityClone clone = getCloneOnServer(entityId, player.worldObj);
			if(clone != null){
				if(clone.canUseThisEntity(player.username)){
					sendToAllWatching(clone);
					clone.commitSuicide();
				}
			}
		}else if(side == Side.CLIENT){
			EntityClone clone = getCloneOnClient(entityId);
			if(clone != null){
				clone.spawnExplosionParticles();
			}
		}


	}





}
